import os
import shutil

# Security
ADMIN_API_KEY = "admin-secret-key-2024"

# JSON file paths
PRODUCTS_DB_FILE = "/app/products_db.json"

# Supported languages dictionary
SUPPORTED_LANGUAGES = {
    'ru': 'ru',
    'en': 'en', 
    'fr': 'fr',
    'de': 'de',
    'he': 'he'
}

# Firefox and geckodriver paths for different environments
## 2. Обновляем `config.py` для Ubuntu:

import os
import shutil

def find_firefox_binary():
    """Find Firefox binary path for current environment"""
    # Ubuntu/Docker приоритет
    possible_paths = [
        '/usr/bin/firefox-esr',  # Ubuntu/Debian Docker
        '/usr/bin/firefox',      # Ubuntu альтернатива
        '/Applications/Firefox.app/Contents/MacOS/firefox',  # macOS разработка
    ]
    
    for path in possible_paths:
        if os.path.exists(path):
            return path
    
    # Fallback
    firefox_path = shutil.which('firefox-esr') or shutil.which('firefox')
    return firefox_path if firefox_path else 'firefox-esr'

def find_geckodriver_binary():
    """Find geckodriver binary path for current environment"""
    # Ubuntu/Docker приоритет
    possible_paths = [
        '/usr/local/bin/geckodriver',  # Docker установка
        '/usr/bin/geckodriver',        # Ubuntu пакет
        '/opt/homebrew/bin/geckodriver',  # macOS M1
    ]
    
    for path in possible_paths:
        if os.path.exists(path):
            return path
    
    # Fallback
    geckodriver_path = shutil.which('geckodriver')
    return geckodriver_path if geckodriver_path else 'geckodriver'

# Устанавливаем пути
FIREFOX_BINARY_PATH = find_firefox_binary()
GECKODRIVER_PATH = find_geckodriver_binary()
