"""
Production configuration for cheapmotorparts.com
"""
import os

# Base configuration
BASE_URL = "https://febest.com.au"
API_BASE_URL = "https://cheapmotorparts.com"

# Browser settings for shared hosting
BROWSER_CONFIG = {
    "headless": True,
    "disable_gpu": True,
    "no_sandbox": True,
    "disable_dev_shm_usage": True,
    "disable_extensions": True,
    "disable_plugins": True,
    "disable_images": True,  # Save bandwidth
    "window_size": "1280,720"
}

# Logging configuration
LOG_LEVEL = "INFO"
LOG_FILE = "app.log"

# Cache settings
CACHE_ENABLED = True
CACHE_TTL = 3600  # 1 hour

# Rate limiting
RATE_LIMIT_ENABLED = True
REQUESTS_PER_MINUTE = 30

# Security
ALLOWED_HOSTS = [
    "cheapmotorparts.com",
    "www.cheapmotorparts.com",
    "api.cheapmotorparts.com"
]

# Database (if needed)
DATABASE_URL = os.getenv("DATABASE_URL", "sqlite:///./products.db")