import requests
import logging
from typing import Dict, Any

logger = logging.getLogger(__name__)

def create_session():
    """
    Create a session with proper headers for web scraping
    """
    session = requests.Session()
    session.headers.update({
        'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36',
        'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
        'Accept-Language': 'en-US,en;q=0.5',
        'Accept-Encoding': 'gzip, deflate',
        'Connection': 'keep-alive',
        'Upgrade-Insecure-Requests': '1',
    })
    return session

def fetch_page(session: requests.Session, url: str) -> str:
    """
    Fetch page content with error handling
    """
    try:
        response = session.get(url, timeout=30)
        if response.status_code == 200:
            return response.text
        else:
            logger.error(f"HTTP {response.status_code} for URL: {url}")
            return ""
    except Exception as e:
        logger.error(f"Error fetching {url}: {str(e)}")
        return ""