from pydantic import BaseModel
from typing import Optional

class ProductCreate(BaseModel):
    """Model for creating a new product"""
    title: str
    brand: str
    price_rub: float
    price_eur: Optional[float] = None
    image: Optional[str] = None
    description: Optional[str] = None
    availability: bool = True

class ProductUpdate(BaseModel):
    """Model for updating product"""
    title: Optional[str] = None
    price_rub: Optional[float] = None
    price_eur: Optional[float] = None
    image: Optional[str] = None
    description: Optional[str] = None
    availability: Optional[bool] = None