#!/usr/bin/env python3
"""
Passenger WSGI configuration for shared hosting
This file is specifically for Passenger-based hosting (common on shared hosts)
"""
import sys
import os
from pathlib import Path

# Add current directory to Python path
current_dir = Path(__file__).parent
sys.path.insert(0, str(current_dir))

# Set environment variables
os.environ.setdefault('PYTHONPATH', str(current_dir))

# Import the application
try:
    from app import app as application
except ImportError as e:
    # Fallback application if import fails
    def application(environ, start_response):
        status = '500 Internal Server Error'
        headers = [('Content-type', 'text/plain')]
        start_response(status, headers)
        return [f'Import error: {str(e)}'.encode()]

# For Passenger compatibility
if __name__ == "__main__":
    from wsgiref.simple_server import make_server
    server = make_server('localhost', 8000, application)
    server.serve_forever()