#!/usr/bin/env python3
"""
Quick test of corrected URL formats
"""

import requests

def quick_test():
    """Quick test of the corrected URL formats"""
    print("🔍 Quick URL Test for febest.com.au")
    print("=" * 50)
    
    # Test the corrected URLs
    test_urls = [
        ("Category (Nissan)", "https://febest.com.au/shop-parts.html?find=nissan"),
        ("Search (Nissan)", "https://febest.com.au/catalogsearch/result/index/?q=nissan"),
        ("Product", "https://febest.com.au/0133-001-febest-rear-leaf-spring-u-bolt-repairkit.html")
    ]
    
    for name, url in test_urls:
        print(f"\n{name}:")
        print(f"URL: {url}")
        try:
            response = requests.get(url, timeout=10, headers={
                'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36'
            })
            print(f"Status: {response.status_code}")
            
            if response.status_code == 200:
                content = response.text.lower()
                if any(indicator in content for indicator in ['product', 'add to cart', 'price']):
                    print("✅ SUCCESS - Contains product content")
                else:
                    print("⚠️ LOADS - But no clear product indicators")
            else:
                print(f"❌ FAILED - HTTP {response.status_code}")
                
        except Exception as e:
            print(f"❌ ERROR - {str(e)}")

if __name__ == "__main__":
    quick_test()