#!/usr/bin/env python3
"""
Simple API test without browser automation
"""

import requests
import time

def test_api_endpoints():
    """Test API endpoints"""
    base_url = "http://localhost:8000"
    
    print("🚀 Testing API Endpoints")
    print("=" * 50)
    
    # Test health first
    print("\n1. Testing Health Endpoint")
    try:
        response = requests.get(f"{base_url}/health", timeout=5)
        print(f"Status: {response.status_code}")
        if response.status_code == 200:
            print("✅ Health endpoint working")
            print(f"Response: {response.json()}")
        else:
            print("❌ Health endpoint failed")
            return
    except Exception as e:
        print(f"❌ Health endpoint error: {e}")
        return
    
    # Test search endpoint
    print("\n2. Testing Search Endpoint")
    try:
        response = requests.get(f"{base_url}/search", params={"query": "brake"}, timeout=30)
        print(f"Status: {response.status_code}")
        if response.status_code == 200:
            data = response.json()
            print(f"✅ Search working - Found {data.get('total_products', 0)} products")
            if data.get('products'):
                print(f"Sample product: {data['products'][0].get('name', 'No name')}")
        else:
            print(f"❌ Search failed: {response.status_code}")
            print(f"Response: {response.text[:200]}")
    except Exception as e:
        print(f"❌ Search error: {e}")
    
    # Test shop-by-mark endpoint
    print("\n3. Testing Shop-by-Mark Endpoint")
    try:
        response = requests.get(f"{base_url}/shop-by-mark", params={"mark": "nissan"}, timeout=60)
        print(f"Status: {response.status_code}")
        if response.status_code == 200:
            data = response.json()
            print(f"✅ Shop-by-mark working - Found {data.get('total_products', 0)} products")
            print(f"Method used: {data.get('method', 'unknown')}")
            print(f"URL used: {data.get('successful_url', 'unknown')}")
            if data.get('products'):
                print(f"Sample product: {data['products'][0].get('name', 'No name')}")
        else:
            print(f"❌ Shop-by-mark failed: {response.status_code}")
            print(f"Response: {response.text[:200]}")
    except Exception as e:
        print(f"❌ Shop-by-mark error: {e}")

if __name__ == "__main__":
    print("Make sure the server is running: python main.py")
    print("Waiting 3 seconds...")
    time.sleep(3)
    test_api_endpoints()