from fastapi import FastAPI
from fastapi.middleware.cors import CORSMiddleware
import logging

from api_routes import (
    search_products,
    shop_by_mark,
    get_product_details,
    analyze_structure_endpoint,
    health_check
)

# Configure logging
logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)

app = FastAPI(
    title="Febest Auto Parts API",
    description="API for scraping auto parts from febest.com.au",
    version="2.0.0"
)

# Configure CORS
app.add_middleware(
    CORSMiddleware,
    allow_origins=["*"],
    allow_credentials=True,
    allow_methods=["*"],
    allow_headers=["*"],
)

# Register routes
app.get("/search")(search_products)
app.get("/shop-by-mark")(shop_by_mark)
app.get("/product-details")(get_product_details)
app.get("/analyze-structure")(analyze_structure_endpoint)
app.get("/health")(health_check)

if __name__ == "__main__":
    import uvicorn
    uvicorn.run(app, host="0.0.0.0", port=8000)