#!/usr/bin/env python3
"""
Test script to check all imports and basic functionality
"""

def test_imports():
    """Test all module imports"""
    try:
        print("Testing imports...")
        
        # Test browser_utils
        print("Importing browser_utils...")
        from browser_utils import create_browser, extract_photos_with_browser, analyze_page_structure
        print("✓ browser_utils imported successfully")
        
        # Test scraper_utils  
        print("Importing scraper_utils...")
        from scraper_utils import parse_products_with_browser, extract_description, parse_product_item
        print("✓ scraper_utils imported successfully")
        
        # Test http_client
        print("Importing http_client...")
        from http_client import create_session, fetch_page
        print("✓ http_client imported successfully")
        
        # Test api_routes
        print("Importing api_routes...")
        from api_routes import search_products, shop_by_mark, get_product_details, analyze_structure_endpoint, health_check
        print("✓ api_routes imported successfully")
        
        # Test main app
        print("Importing main app...")
        import test
        print("✓ main app imported successfully")
        
        print("\n✅ All imports successful!")
        return True
        
    except Exception as e:
        print(f"\n❌ Import error: {str(e)}")
        import traceback
        traceback.print_exc()
        return False

def test_basic_functionality():
    """Test basic functionality"""
    try:
        print("\nTesting basic functionality...")
        
        # Test session creation
        from http_client import create_session
        session = create_session()
        print("✓ HTTP session created")
        
        # Test health check
        from api_routes import health_check
        health_result = health_check()
        print(f"✓ Health check: {health_result}")
        
        print("\n✅ Basic functionality tests passed!")
        return True
        
    except Exception as e:
        print(f"\n❌ Functionality error: {str(e)}")
        import traceback
        traceback.print_exc()
        return False

if __name__ == "__main__":
    print("🔍 Running import and functionality tests...\n")
    
    imports_ok = test_imports()
    if imports_ok:
        functionality_ok = test_basic_functionality()
        
        if imports_ok and functionality_ok:
            print("\n🎉 All tests passed! The application should work correctly.")
        else:
            print("\n⚠️  Some tests failed. Check the errors above.")
    else:
        print("\n⚠️  Import tests failed. Fix import errors first.")