import requests
from config import SUPPORTED_LANGUAGES

# Translation dictionary for system messages
TRANSLATIONS = {
    'ru': {
        'brand_name': 'Название бренда',
        'page_number': 'Номер страницы',
        'product_identifier': 'Идентификатор товара из URL',
        'products_not_found': 'Товары не найдены на странице',
        'product_not_found': 'Товар не найден или страница не загрузилась',
        'product_info_not_found': 'Информация о товаре не найдена на странице',
        'error_getting_products': 'Ошибка при получении товаров',
        'error_getting_product_info': 'Ошибка при получении информации о товаре',
        'total_products': 'Всего товаров',
        'products': 'Товары',
        'brand': 'Бренд',
        'page': 'Страница',
        'category_url': 'URL категории',
        'title': 'Название',
        'price': 'Цена',
        'old_price': 'Старая цена',
        'discount': 'Скидка',
        'description': 'Описание',
        'images': 'Изображения',
        'sizes': 'Размеры',
        'availability': 'Наличие'
    },
    'en': {
        'brand_name': 'Brand name',
        'page_number': 'Page number',
        'product_identifier': 'Product identifier from URL',
        'products_not_found': 'Products not found on page',
        'product_not_found': 'Product not found or page did not load',
        'product_info_not_found': 'Product information not found on page',
        'error_getting_products': 'Error getting products',
        'error_getting_product_info': 'Error getting product information',
        'total_products': 'Total products',
        'products': 'Products',
        'brand': 'Brand',
        'page': 'Page',
        'category_url': 'Category URL',
        'title': 'Title',
        'price': 'Price',
        'old_price': 'Old price',
        'discount': 'Discount',
        'description': 'Description',
        'images': 'Images',
        'sizes': 'Sizes',
        'availability': 'Availability'
    },
    'fr': {
        'brand_name': 'Nom de la marque',
        'page_number': 'Numéro de page',
        'product_identifier': 'Identifiant du produit depuis l\'URL',
        'products_not_found': 'Produits non trouvés sur la page',
        'product_not_found': 'Produit non trouvé ou la page ne s\'est pas chargée',
        'product_info_not_found': 'Informations sur le produit non trouvées sur la page',
        'error_getting_products': 'Erreur lors de l\'obtention des produits',
        'error_getting_product_info': 'Erreur lors de l\'obtention des informations sur le produit',
        'total_products': 'Total des produits',
        'products': 'Produits',
        'brand': 'Marque',
        'page': 'Page',
        'category_url': 'URL de catégorie',
        'title': 'Titre',
        'price': 'Prix',
        'old_price': 'Ancien prix',
        'discount': 'Remise',
        'description': 'Description',
        'images': 'Images',
        'sizes': 'Tailles',
        'availability': 'Disponibilité'
    },
    'de': {
        'brand_name': 'Markenname',
        'page_number': 'Seitennummer',
        'product_identifier': 'Produktkennung aus URL',
        'products_not_found': 'Produkte auf der Seite nicht gefunden',
        'product_not_found': 'Produkt nicht gefunden oder Seite wurde nicht geladen',
        'product_info_not_found': 'Produktinformationen auf der Seite nicht gefunden',
        'error_getting_products': 'Fehler beim Abrufen der Produkte',
        'error_getting_product_info': 'Fehler beim Abrufen der Produktinformationen',
        'total_products': 'Gesamtprodukte',
        'products': 'Produkte',
        'brand': 'Marke',
        'page': 'Seite',
        'category_url': 'Kategorie-URL',
        'title': 'Titel',
        'price': 'Preis',
        'old_price': 'Alter Preis',
        'discount': 'Rabatt',
        'description': 'Beschreibung',
        'images': 'Bilder',
        'sizes': 'Größen',
        'availability': 'Verfügbarkeit'
    },
    'he': {
        'brand_name': 'שם המותג',
        'page_number': 'מספר עמוד',
        'product_identifier': 'מזהה מוצר מכתובת URL',
        'products_not_found': 'מוצרים לא נמצאו בעמוד',
        'product_not_found': 'מוצר לא נמצא או שהעמוד לא נטען',
        'product_info_not_found': 'מידע על המוצר לא נמצא בעמוד',
        'error_getting_products': 'שגיאה בקבלת מוצרים',
        'error_getting_product_info': 'שגיאה בקבלת מידע על המוצר',
        'total_products': 'סך הכל מוצרים',
        'products': 'מוצרים',
        'brand': 'מותג',
        'page': 'עמוד',
        'category_url': 'כתובת קטגוריה',
        'title': 'כותרת',
        'price': 'מחיר',
        'old_price': 'מחיר ישן',
        'discount': 'הנחה',
        'description': 'תיאור',
        'images': 'תמונות',
        'sizes': 'מידות',
        'availability': 'זמינות'
    }
}

def get_translation(key: str, language: str = 'ru') -> str:
    """
    Get translation for a given key and language
    
    Args:
        key: Translation key
        language: Target language code
    
    Returns:
        Translated string
    """
    if language in TRANSLATIONS and key in TRANSLATIONS[language]:
        return TRANSLATIONS[language][key]
    # Fallback to Russian if translation not found
    return TRANSLATIONS['ru'].get(key, key)

def translate_text(text: str, target_language: str) -> str:
    """Translate text using Google Translate API via requests"""
    if not text or target_language == 'ru':
        return text
    
    try:
        # Google Translate URL
        url = "https://translate.googleapis.com/translate_a/single"
        params = {
            'client': 'gtx',
            'sl': 'ru',  # source language
            'tl': target_language,  # target language
            'dt': 't',
            'q': text
        }
        
        response = requests.get(url, params=params, timeout=5)
        if response.status_code == 200:
            result = response.json()
            if result and len(result) > 0 and len(result[0]) > 0:
                return result[0][0][0]
    except Exception as e:
        print(f"Translation error: {e}")
    
    return text